<?php
/**
 * Publish Comment
 *
 * @package     AutomatorWP\Integrations\AnsPress\Triggers\Publish_Comment
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_AnsPress_Publish_Comment extends AutomatorWP_Integration_Trigger {

    public $integration = 'anspress';
    public $trigger = 'anspress_publish_comment';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User comments on an answers or question', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>comments</strong> on an answers or question', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User comments on an answers or question %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User comments on an answers or question', 'automatorwp-pro' ),
            'action'            => 'ap_publish_comment',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags(),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param WP_Comment $comment
     */
    public function listener( $comment ) {

        $comment_id = $comment->comment_ID;
        $user_id = $comment->user_id;
        $post_id = $comment->comment_post_ID;

        automatorwp_trigger_event( array(
            'trigger'       => $this->trigger,
            'user_id'       => $user_id,
            'post_id'       => $post_id,
            'comment_id'    => $comment_id,
        ) );

    }

}

new AutomatorWP_AnsPress_Publish_Comment();